USE [SBSMonitoring]
GO

/****** Object:  StoredProcedure [dbo].[InsertEventLogData]    Script Date: 01/04/2012 10:20:26 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


ALTER PROCEDURE [dbo].[InsertEventLogData] 
	@EventLogData xml
AS
BEGIN

SET NOCOUNT ON;

DECLARE @docHandle int

EXEC sp_xml_preparedocument @docHandle OUTPUT, @EventLogData

DECLARE EventCursor CURSOR STATIC FOR
	SELECT *
	FROM OPENXML (@docHandle, '/Events/Event')
		  WITH (DateOccured		nvarchar(50) '@DateOccured',
				EventLogPath	nvarchar(100) '@EventLog',
				EventID			nvarchar(50) '@EventID',
				EventTypeString	nvarchar(50) '@EventTypeString',
				EventTypeCode	nvarchar(50) '@EventTypeCode',
				EventSource		nvarchar(100) '@EventSource',
				EventProvider	nvarchar(100) '@EventProvider',
				EventMessage nvarchar(4000) '@EventMessage')

OPEN EventCursor
IF (@@CURSOR_ROWS > 0)
BEGIN
	DECLARE @DateOccured	nvarchar(50)
	DECLARE @Path			nvarchar(max)
	DECLARE @ID				int
	DECLARE @TypeString		nvarchar(50)
	DECLARE @TypeCode		nvarchar(50)
	DECLARE @Source			nvarchar(max)
	DECLARE @Provider		nvarchar(max)
	DECLARE @Message		nvarchar(4000)

	DECLARE @EventLogPathID int
	DECLARE @EventTypeID int
	DECLARE @EventSourceID int
	DECLARE @EventProviderID int
	DECLARE @EventMessageID int

	FETCH NEXT FROM EventCursor INTO @DateOccured, @Path, @ID, @TypeString, @TypeCode, @Source, @Provider, @Message
	WHILE (@@FETCH_STATUS = 0)
	BEGIN
		SET TRANSACTION ISOLATION LEVEL SERIALIZABLE
		BEGIN TRANSACTION

		SELECT @EventLogPathID = (SELECT [ID] from EventLogPath where [Name]=@Path)
		IF (@EventLogPathID IS NULL)
		BEGIN
			INSERT INTO EventLogPath ([Name]) VALUES (@Path)
			SELECT @EventLogPathID = (SELECT ID from EventLogPath where [Name]=@Path)
		END

		SELECT @EventTypeID = (SELECT [ID] from EventType WHERE [EventTypeID]=@TypeCode)
		IF (@EventTypeID IS NULL)
		BEGIN
			INSERT INTO EventType ([EventTypeID], Description) VALUES (@TypeCode, @TypeString)
			SELECT @EventTypeID = (SELECT [ID] from EventType WHERE [EventTypeID]=@TypeCode)
		END

		SELECT @EventSourceID = (SELECT [ID] FROM EventLogSource WHERE [Source]=@Source)
		IF (@EventSourceID IS NULL)
		BEGIN
			INSERT INTO EventLogSource ([Source]) VALUES (@Source)
			SELECT @EventSourceID = (SELECT [ID] FROM EventLogSource WHERE [Source]=@Source)
		END

		SELECT @EventProviderID = (SELECT [ID] FROM EventLogProvider WHERE [Provider]=@Provider)
		IF (@EventProviderID IS NULL)
		BEGIN
			INSERT INTO EventLogProvider ([Provider]) VALUES (@Provider)
			SELECT @EventProviderID = (SELECT [ID] FROM EventLogProvider WHERE [Provider]=@Provider)
		END

		SELECT @EventMessageID = (SELECT [ID] FROM EventLogMessage WHERE [Message]=@Message)
		IF (@EventMessageID IS NULL)
		BEGIN
			INSERT INTO EventLogMessage ([Message]) VALUES (@Message)
			SELECT @EventMessageID = (SELECT [ID] FROM EventLogMessage WHERE [Message]=@Message)
		END

		COMMIT TRANSACTION
		SET TRANSACTION ISOLATION LEVEL READ COMMITTED

		IF (NOT EXISTS(SELECT * FROM dbo.EventLogExclusions WHERE EventLogExclusions.EventID = @ID and EventLogExclusions.SourceID = @EventSourceID))
		BEGIN
			INSERT INTO EventLog ([DateOccured], [EventLogPathID], [EventID], [EventTypeID], [SourceID], [ProviderID], [MessageID]) 
					VALUES (dbo.TicksToDateTime(@DateOccured), @EventLogPathID, @ID, @EventTypeID, @EventSourceID, @EventProviderID, @EventMessageID)
		END
		FETCH NEXT FROM EventCursor INTO @DateOccured, @Path, @ID, @TypeString, @TypeCode, @Source, @Provider, @Message
	END
END

CLOSE EventCursor
DEALLOCATE EventCursor

EXEC sp_xml_removedocument @docHandle

END


GO

